import { setupShallowTest } from '../../tests/helpers';
import { ButtonIcon } from '../button/button-icon';
import { Background } from '../styled-layout';
import {
  InFeatureNotification,
  InFeatureNotificationProps,
  InFeatureNotificationType,
} from './component';

function getRequiredProps(): InFeatureNotificationProps {
  return {
    closeButtonAriaLabel: 'Close',
    description: 'Here is a descriptive description',
    title: 'This is a Title',
    type: InFeatureNotificationType.Info,
  };
}

function getOptionalProps(): InFeatureNotificationProps {
  return {
    ...getRequiredProps(),
    avatar: {
      src: 'http://twitch.tv/doobix/avatar.jpg',
      alt: "doobix's Avatar",
      size: 30,
    },
    background: Background.Alt,
    link: {
      to: 'http://www.twitch.tv/doobix',
    },
    actions: [{
      children: 'Primary Button',
    }, {
      children: 'Secondary Button',
    }],
    closeButtonOnClick: jest.fn(),
  };
}

const setupShallow = setupShallowTest(InFeatureNotification, getRequiredProps);

describe('InFeatureNotification', () => {
  it('renders in-feature notification component with only required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders in-feature notification component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders in-feature notification component in narrow mode', () => {
    const { wrapper } = setupShallow({ ...getOptionalProps(), narrow: true });
    expect(wrapper).toMatchSnapshot();
  });

  it('invokes closeButtonOnClick when the close button is clicked', () => {
    const closeButtonOnClick = jest.fn();
    const { wrapper } = setupShallow({ closeButtonOnClick });
    expect(closeButtonOnClick).toHaveBeenCalledTimes(0);
    wrapper.find(ButtonIcon).simulate('click');
    expect(closeButtonOnClick).toHaveBeenCalledTimes(1);
  });
});
