import { setupShallowTest } from '../../tests/helpers';
import {
  Interactable,
  InteractableProps,
  InteractableType,
} from './component';

function getOptionalProps(): InteractableProps {
  return {
    type: InteractableType.Base,
    ariaLabel: 'Test aria label',
    blurAfterClick: true,
    disabled: true,
    hover: true,
    linkTo: '/',
    onClick: jest.fn(),
    selected: true,
    tabIndex: 0,
    targetBlank: true,
    title: 'test title',
  };
}

const setupShallow = setupShallowTest(Interactable);

describe('Interactable', () => {
  it('renders interactable component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders interactable component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders interactable component as <button> with an onclick', () => {
    const { wrapper } = setupShallow({ onClick: jest.fn() });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders interactable component as <a>', () => {
    const { wrapper } = setupShallow({ linkTo: 'https://www.google.com' });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders interactable component as Link component', () => {
    const { wrapper } = setupShallow({ linkTo: '/' });
    expect(wrapper).toMatchSnapshot();
  });
});
