import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { CoreInteractive, CoreInteractivePublicProps } from '../core-interactive';
import { Display } from '../layout';
import { BorderRadius, InjectStyledLayout } from '../styled-layout';
import './styles.scss';

export enum InteractableType {
  Inverted = 'tw-interactable--inverted',
  Alpha = 'tw-interactable--alpha',
  Alert = 'tw-interactable--alert',
  Base = 'tw-interactable--base',
  Alt = 'tw-interactable--alt',
  Overlay = 'tw-interactable--overlay',
}

export interface InteractableProps extends CoreInteractivePublicProps {
  border?: boolean;
  borderRadius?: BorderRadius;
  /**
   * @example Interactable Text
   */
  children?: React.ReactNode;
  hover?: boolean;
  selected?: boolean;
  type?: InteractableType;
}

export class Interactable extends React.Component<InteractableProps, {}> {
  public render() {
    return (
      <InjectStyledLayout
        display={Display.Block}
        borderRadius={this.props.borderRadius}
        fullWidth
      >
        <CoreInteractive
          {...this.props}
          className={this.className}
          {...getDataProps(this.props)}
        >
          {this.props.children}
        </CoreInteractive>
      </InjectStyledLayout>
    );
  }

  private get className() {
    const classes: ClassValue = {
      'tw-interactable': true,
      'tw-interactable--selected': this.props.selected,
      'tw-interactable--hover': this.props.hover,
      'tw-interactable--disabled': this.props.disabled,
      'tw-interactable--border': this.props.border,
      [this.props.type || InteractableType.Inverted]: true,
    };

    return cn(classes);
  }
}
