import * as React from 'react';
import { AriaCurrent, AriaHasPopup, AriaInvalid, AriaLive, AriaRelevant, AriaRole } from '../../aria/aria';
import { setupShallowTest } from '../../tests/helpers';
import {
  AlignContent,
  AlignItems,
  AlignSelf,
  Display,
  FlexDirection,
  FlexWrap,
  InjectLayout,
  JustifyContent,
  Layout,
  LayoutProps,
  Overflow,
  Position,
  Resize,
  TextAlign,
  VerticalAlign,
  Visibility,
  ZIndex,
} from './component';

function getBreakpointProps(): LayoutProps {
  return {
    alignContent: AlignContent.Center,
    alignItems: AlignItems.Start,
    alignSelf: AlignSelf.Center,
    display: Display.InlineBlock,
    flexDirection: FlexDirection.ColumnReverse,
    flexGrow: 2,
    flexOrder: 1,
    flexShrink: 0,
    flexWrap: FlexWrap.WrapReverse,
    justifyContent: JustifyContent.Start,
    margin: { top: 2, left: 3, right: 1, bottom: 0.5 },
    padding: { top: 2, left: 3, right: 1, bottom: 0.5 },
    position: Position.Absolute,
    textAlign: TextAlign.Right,
    visibility: Visibility.Hidden,
  };
}

function getOptionalProps(): LayoutProps {
  return {
    attachTop: true,
    attachRight: true,
    attachBottom: true,
    attachLeft: true,
    children: <div />,
    className: 'test-classname',
    ellipsis: true,
    fullHeight: true,
    fullWidth: true,
    overflow: Overflow.Hidden,
    resize: Resize.X,
    verticalAlign: VerticalAlign.Middle,
    zIndex: ZIndex.Below,
    breakpointExtraSmall: getBreakpointProps(),
    breakpointSmall: getBreakpointProps(),
    breakpointMedium: getBreakpointProps(),
    breakpointLarge: getBreakpointProps(),
    breakpointExtraLarge: getBreakpointProps(),
    breakpointExtraExtraLarge: getBreakpointProps(),
    role: AriaRole.Tree,
    ariaAtomic: true,
    ariaBusy: true,
    ariaControls: 'controls',
    ariaCurrent: AriaCurrent.Time,
    ariaDescribedby: 'described-by',
    ariaDetails: 'details',
    ariaDisabled: true,
    ariaErrormessage: 'error-message',
    ariaFlowto: 'flow-to',
    ariaHaspopup: AriaHasPopup.Dialog,
    ariaHidden: true,
    ariaInvalid: AriaInvalid.Spelling,
    ariaKeyshortcuts: 'key-shortcuts',
    ariaLabel: 'label',
    ariaLabelledby: 'labelled-by',
    ariaLive: AriaLive.Assertive,
    ariaOwns: 'owns',
    ariaRelevant: AriaRelevant.Text,
    ariaRoledescription: 'role-description',
  };
}

const setupShallowLayout = setupShallowTest(Layout);

describe('Layout', () => {
  it('renders inject layout component with required props', () => {
    const { wrapper } = setupShallowLayout();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders layout component with all props', () => {
    const { wrapper } = setupShallowLayout(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});

const setupShallowInject = setupShallowTest(InjectLayout);

describe('InjectLayout', () => {
  it('renders inject layout component with required props', () => {
    const { wrapper } = setupShallowInject({ children: <div /> });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders layout component with all props', () => {
    const { wrapper } = setupShallowInject(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
