import * as React from 'react';
import { ButtonIcon } from '../../button/button-icon';
import { SVGAsset } from '../../svg';

export enum PaginationControlType {
  Default = 0,
  Previous,
  Next,
}

export interface PaginationControlProps {
  /**
   * Aria Label necessary to make the control accessible.
   * @example Go to Next Page
   */
  ariaLabel: string;
  /**
   * Represents the current page of data.
   * @example 1
   */
  currentPage: number;
  /**
   * Represents the total number of pages available from the dataset.
   * @example 10
   */
  totalPages: number;
  /**
   * Event handler triggered when the control button is clicked.
   */
  onClick?: React.MouseEventHandler<HTMLElement>;
  /**
   * The type of control to display.
   */
  type: PaginationControlType;
}

export const PaginationControl: React.SFC<PaginationControlProps> = (props) => {
  const type = PaginationControlType[props.type];

  return (
    <ButtonIcon
      icon={type === 'Previous' ? SVGAsset.GlyphArrLeft : SVGAsset.GlyphArrRight}
      ariaLabel={props.ariaLabel}
      onClick={props.onClick}
      disabled={type === 'Previous' && props.currentPage === 1 || type === 'Next' && props.currentPage === props.totalPages}
    />
  );
};

PaginationControl.displayName = 'PaginationControl';
