import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import './styles.scss';

export enum PillType {
  Notification = 'tw-pill--notification',
  Brand = 'tw-pill--brand',
  Live = 'tw-pill--live',
  Alert = 'tw-pill--alert',
  Success = 'tw-pill--success',
  Prime = 'tw-pill--prime',
  Overlay = 'tw-pill--overlay',
  Warn = 'tw-pill--warn',
}

export interface PillProps {
  /**
   * @example Beta
   */
  label: string;
  type?: PillType;
}

export const Pill: React.SFC<PillProps> = (props) => {
  const classes: ClassValue = {
    'tw-pill': true,
  };

  if (props.type) {
    classes[props.type] = true;
  }

  return (
    <span className={cn(classes)} {...getDataProps(props)}>{props.label}</span>
  );
};

Pill.displayName = 'Pill';
