import { setupShallowTest } from '../../tests/helpers';
import {
  Placeholder,
  PlaceholderProps,
} from './component';

function getOptionalProps(): PlaceholderProps {
  return {
    lineCount: 2,
    overlay: true,
    height: 100,
    width: 100,
  };
}

const setupShallow = setupShallowTest(Placeholder);

describe('Placeholder', () => {
  it('renders placeholder component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders placeholder component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
