import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import './styles.scss';

export interface PlaceholderProps {
  lineCount?: number;
  overlay?: boolean;
  height?: number;
  width?: number;
}

/**
 * Placeholder content helps ease the pain of loading. They provide content
 * while the page is fetching data allowing for the page to take shape and
 * help make the page load feel faster.
 */
export const Placeholder: React.SFC<PlaceholderProps> = (props) => {
  const classes: ClassValue = {
    'tw-placeholder': true,
    'tw-placeholder--overlay': props.overlay,
    'tw-placeholder--fill': !props.lineCount,
    'tw-placeholder--custom-height': !!props.height,
  };

  const styles = {
    width: props.width ? `${props.width / 10}rem` : '',
    height: props.height ? `${props.height / 10}rem` : '',
  };

  const placeholders = [];

  for (let i = 0; i < (props.lineCount || 1); i++) {
    placeholders.push(<span className={cn(classes)} key={i} style={styles} />);
  }

  return (
    <span className="tw-placeholder-wrapper" {...getDataProps(props)}>
      {placeholders}
    </span>
  );
};

Placeholder.displayName = 'Placeholder';
