import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { Display, Layout, Position } from '../layout';
import { BorderRadius, StyledLayout } from '../styled-layout';
import './styles.scss';

export enum PresenceStatus {
  Offline = 'tw-presence__indicator--offline',
  Invisible = 'tw-presence__indicator--invisible',
  Online = 'tw-presence__indicator--online',
  Busy = 'tw-presence__indicator--busy',
  Away = 'tw-presence__indicator--away',
}

export interface PresenceProps {
  status?: PresenceStatus;
  border?: boolean;
}

export const Presence: React.SFC<PresenceProps> = (props) => {
  const classes: ClassValue = {
    'tw-presence': true,
    'tw-presence--border': props.border,
  };

  const indicatorClasses: ClassValue = {};

  if (props.status) {
    indicatorClasses[props.status] = true;
  } else {
    indicatorClasses[PresenceStatus.Offline] = true;
  }

  return (
    <Layout
      className={cn(classes)}
      display={Display.InlineFlex}
      position={Position.Relative}
      {...getDataProps(props)}
    >
      <StyledLayout
        className="tw-presence__border"
        borderRadius={BorderRadius.Small}
        position={Position.Absolute}
      />
      <StyledLayout
        className={`tw-presence__indicator ${cn(indicatorClasses)}`}
        position={Position.Absolute}
        attachTop
        attachLeft
      />
    </Layout>
  );
};

Presence.displayName = 'Presence';
