import { setupShallowTest } from '../../tests/helpers';
import {
  ProgressBar,
  ProgressBarAnimationDirection,
  ProgressBarProps,
  ProgressBarSize,
  ProgressBarStatus,
} from './component';

function getOptionalProps(): ProgressBarProps {
  return {
    animationDuration: 10,
    animationDirection: ProgressBarAnimationDirection.Down,
    onAnimationEnd: jest.fn(),
    size: ProgressBarSize.ExtraSmall,
    status: ProgressBarStatus.Success,
    value: 100,
    inherit: true,
    mask: true,
  };
}

const setupShallow = setupShallowTest(ProgressBar);

describe('ProgressBar', () => {
  it('renders progress bar component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders progress bar component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
