import * as React from 'react';
import { cn } from '../../utils/classnames';
import './styles.scss';

export interface ResponsiveWrapperProps {
  centered?: boolean;
  /**
   * @example
   * <StyledLayout color={Color.Overlay} textAlign={TextAlign.Center} background={Background.Accent} padding={2}>Inspect my container to see my max-width</StyledLayout>
   */
  children: React.ReactNode;
}

export const ResponsiveWrapper: React.SFC<ResponsiveWrapperProps> = (props) => {
  const classes: ClassValue = {
    'tw-responsive-wrapper': true,
    'tw-responsive-wrapper--centered': props.centered,
  };

  return (
    <div className={cn(classes)}>
      {props.children}
    </div>
  );
};

ResponsiveWrapper.displayName = 'ResponsiveWrapper';
