import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { SVG, SVGAsset, SVGType } from '../svg';
import { Tooltip, TooltipAlign, TooltipDirection } from '../tooltip';
import './styles.scss';

export interface StatProps {
  /**
   * @example Viewers
   */
  label: string;
  /**
   * @example 3,000
   */
  value: string;
  /**
   * @example GlyphViews
   */
  icon: SVGAsset;
  tooltipDirection?: TooltipDirection;
  tooltipAlign?: TooltipAlign;
}

export const Stat: React.SFC<StatProps> = (props) => {
  const classes: ClassValue = {
    'tw-stat': true,
  };

  let icon;

  if (props.icon) {
    icon = (<SVG type={SVGType.Inherit} asset={props.icon}/>);
  }

  let stat = (
      <div className={cn(classes)} {...getDataProps(props)}>
        <span className="tw-stat__icon">{icon}</span>
        <span className="tw-stat__value" data-a-target="tw-stat-value">{props.value}</span>
      </div>
  );

  if (!props.label) {
    return stat;
  } else {
    return (
      <Tooltip
        direction={props.tooltipDirection ? props.tooltipDirection : TooltipDirection.Bottom}
        align={props.tooltipAlign ? props.tooltipAlign : TooltipAlign.Center}
        label={props.label}
      >
        {stat}
      </Tooltip>
    );
  }

};

Stat.displayName = 'Stat';
