import { AriaCurrent, AriaHasPopup, AriaInvalid, AriaLive, AriaRelevant, AriaRole } from '../../aria/aria';
import { setupShallowTest } from '../../tests/helpers';
import { Color, FontSize } from '../core-text';
import {
  Background,
  BorderRadius,
  StyledLayout,
  StyledLayoutProps,
} from './component';

function getBreakpointProps(): StyledLayoutProps {
  return {
    fontSize: FontSize.Size4,
  };
}

function getOptionalProps(): StyledLayoutProps {
  return {
    background: Background.AccentAlt2,
    border: true,
    borderTop: true,
    borderRight: true,
    borderBottom: true,
    borderLeft: true,
    borderMarked: true,
    borderRadius: BorderRadius.Rounded,
    color: Color.Live,
    elevation: 3,
    breakpointExtraSmall: getBreakpointProps(),
    breakpointSmall: getBreakpointProps(),
    breakpointMedium: getBreakpointProps(),
    breakpointLarge: getBreakpointProps(),
    breakpointExtraLarge: getBreakpointProps(),
    breakpointExtraExtraLarge: getBreakpointProps(),
    role: AriaRole.Tree,
    ariaAtomic: true,
    ariaBusy: true,
    ariaControls: 'controls',
    ariaCurrent: AriaCurrent.Time,
    ariaDescribedby: 'described-by',
    ariaDetails: 'details',
    ariaDisabled: true,
    ariaErrormessage: 'error-message',
    ariaFlowto: 'flow-to',
    ariaHaspopup: AriaHasPopup.Dialog,
    ariaHidden: true,
    ariaInvalid: AriaInvalid.Spelling,
    ariaKeyshortcuts: 'key-shortcuts',
    ariaLabel: 'label',
    ariaLabelledby: 'labelled-by',
    ariaLive: AriaLive.Assertive,
    ariaOwns: 'owns',
    ariaRelevant: AriaRelevant.Text,
    ariaRoledescription: 'role-description',
  };
}

function getBorderRadiusDirectionsProp(): StyledLayoutProps {
  return {
    borderRadius: {
      topLeft: BorderRadius.Large,
      topRight: BorderRadius.Medium,
      bottomRight: BorderRadius.Small,
      bottomLeft: BorderRadius.None,
    },
  };
}

const setupShallow = setupShallowTest(StyledLayout);

describe('StyledLayout', () => {
  it('renders styled layout component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders styled layout component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders styled layout component with directional border radius', () => {
    const { wrapper } = setupShallow(getBorderRadiusDirectionsProp());
    expect(wrapper).toMatchSnapshot();
  });
});
