import { setupShallowTest } from '../../../tests/helpers';
import {
  AnimatedGlitchLogo, AnimatedGlitchLogoProps,
} from './component';

function getOptionalProps(): AnimatedGlitchLogoProps {
  return {
    height: 40,
    width: 40,
    padding: 1,
  };
}

const setupShallow = setupShallowTest(AnimatedGlitchLogo);

describe('AnimatedGlitchLogo', () => {
  it('renders svg component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders svg component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('adds approparite class names on mouseenter', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseEnter');
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-enter');
  });

  it('adds approparite class names on mouseleave', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseLeave');
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-leave');
  });

  it('adds approparite class names on mousedown', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseDown');
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-down');
  });

  it('adds approparite class names on mouseup', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseUp');
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-up');
  });

  it('uses the animation queue correctly to queue animations and not immediately skip animation steps', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseDown');
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseUp');
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseLeave');
    // Here Mouse Down is expected to play completely before Mouse Up is started; the other events get queued for later.
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-down');
  });

  it('uses the animation queue and allows mouse down to immediately interrupt animations to provide a responsive UX', () => {
    const { wrapper } = setupShallow();
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseUp');
    wrapper.find('.tw-animated-glitch-logo').simulate('mouseDown');
    // Here Mouse Down is expected to interrupt and override any existing animations in the queue, even though it is called second.
    expect(wrapper.find('.tw-animated-glitch-logo__body')).toHaveClassName('tw-animated-glitch-logo__body--mouse-down');
  });
});
