import { setupShallowTest } from '../../tests/helpers';
import {
  SVG,
  SVGAsset,
  SVGProps,
  SVGType,
} from './component';

function getRequiredProps(): SVGProps {
  return {
    asset: SVGAsset.Gear,
  };
}

function getOptionalProps(): SVGProps {
  return {
    asset: SVGAsset.Gear,
    height: 40,
    width: 40,
    fill: true,
    type: SVGType.Alt2,
  };
}

const setupShallow = setupShallowTest(SVG);

describe('SVG', () => {
  it('renders svg component with required props', () => {
    const { wrapper } = setupShallow(getRequiredProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders svg component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
