import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import './styles.scss';

export interface TableBodyProps {
  children?: React.ReactNode;
}

export const TableBody: React.SFC<TableBodyProps> = (props) => {
  const classes: ClassValue = {};

  return (
    <div className={cn('tw-table-body', classes)} {...getDataProps(props)}>
      {props.children}
    </div>
  );
};

TableBody.displayName = 'TableBody';
