import { setupShallowTest } from '../../../tests/helpers';
import { TextAlign, VerticalAlign } from '../../layout';
import {
  TableCell,
  TableCellProps,
} from './component';

function getOptionalProps(): TableCellProps {
  return {
    textAlign: TextAlign.Right,
    verticalAlign: VerticalAlign.TextTop,
  };
}

const setupShallow = setupShallowTest(TableCell);

describe('TableCell', () => {
  it('renders table cell component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders table cell component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
