import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { Layout, TextAlign } from '../../layout';
import { VerticalAlign } from '../../layout';
import './styles.scss';

export interface TableCellProps {
  children?: React.ReactNode;
  textAlign?: TextAlign;
  verticalAlign?: VerticalAlign;
}

export const TableCell: React.SFC<TableCellProps> = (props) => {
  const classes: ClassValue = {
    'tw-table-cell': true,
  };

  return (
    <Layout padding={1} className={cn(classes)} textAlign={props.textAlign} verticalAlign={props.verticalAlign} {...getDataProps(props)}>
      {props.children}
    </Layout>
  );
};

TableCell.displayName = 'TableCell';
