import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { Background, StyledLayout } from '../../styled-layout';
import './styles.scss';

export interface TableHeaderProps {
  children?: React.ReactNode;
}

export const TableHeader: React.SFC<TableHeaderProps> = (props) => {
  const classes: ClassValue = {};

  return (
    <StyledLayout background={Background.Alt} className={cn('tw-table-header', classes)} {...getDataProps(props)}>
      {props.children}
    </StyledLayout>
  );
};

TableHeader.displayName = 'TableHeader';
