import { setupShallowTest } from '../../../tests/helpers';
import { TextAlign, VerticalAlign } from '../../layout';
import {
  Sorting,
  TableHeading,
  TableHeadingProps,
} from './component';

function getOptionalProps(): TableHeadingProps {
  return {
    label: 'Test label',
    onClick: jest.fn(),
    sorting: Sorting.Ascending,
    verticalAlign: VerticalAlign.Middle,
    textAlign: TextAlign.Right,
  };
}

const setupShallow = setupShallowTest(TableHeading);

describe('TableHeading', () => {
  it('renders table heading component with required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders table heading component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
