import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import './styles.scss';

export interface TableRowProps {
  children?: React.ReactNode;
}

export const TableRow: React.SFC<TableRowProps> = (props) => {
  const classes: ClassValue = {};

  return (
    <div className={cn('tw-table-row', classes)} {...getDataProps(props)}>
      {props.children}
    </div>
  );
};

TableRow.displayName = 'TableRow';
