import * as React from 'react';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import './styles.scss';

export interface TableProps {
  alternateRows?: boolean;
  children?: React.ReactNode;
}

export const Table: React.SFC<TableProps> = (props) => {
  const classes: ClassValue = {};

  if (props.alternateRows) {
    classes['tw-table--alternate-rows'] = true;
  }

  return (
    <div className={cn('tw-table', classes)} {...getDataProps(props)}>
      {props.children}
    </div>
  );
};

Table.displayName = 'Table';
