import * as React from 'react';
import { AriaRole } from '../../../aria/aria';
import { getDataProps } from '../../../utils/data-props';
import { Display, InjectLayout, JustifyContent } from '../../layout';
import './styles.scss';

export interface TabWrapperProps {
  alignRight?: boolean;
  /**
   * @example <Tab active>Games</Tab>
   *   <Tab>Communities</Tab>
   *   <Tab>Popular</Tab>
   *   <Tab>Creative</Tab>
   */
  children?: React.ReactNode;
}

export const TabWrapper: React.SFC<TabWrapperProps> = (props) => {
  return (
    <InjectLayout
      fullWidth
      display={Display.Flex}
      justifyContent={props.alignRight ? JustifyContent.End : undefined}
      role={AriaRole.TabList}
      {...getDataProps(props)}
    >
      <ul className={`tw-tab-wrapper`}>
        {props.children}
      </ul>
    </InjectLayout>
  );
};

TabWrapper.displayName = 'TabWrapper';
