import * as React from 'react';
import { AriaRole } from '../../../aria/aria';
import { cn } from '../../../utils/classnames';
import { getDataProps } from '../../../utils/data-props';
import { CoreInteractive, CoreInteractivePublicProps } from '../../core-interactive';
import { Display, InjectLayout } from '../../layout';
import './styles.scss';

export interface TabProps extends CoreInteractivePublicProps {
  active?: boolean;
  /**
   * @example Discover
   */
  children?: React.ReactNode;
}

export class Tab extends React.Component<TabProps, {}> {
  public render() {
    return (
      <li className={this.className} role={AriaRole.Presentation} {...getDataProps(this.props)}>
        <InjectLayout display={Display.InlineFlex}>
          <CoreInteractive
            className={`tw-tab__link ${this.props.active ? 'tw-tab__link--active' : ''}`}
            data-a-target="tw-tab-link"
            role={AriaRole.Tab}
            ariaLabel={this.props.ariaLabel}
            disabled={this.props.disabled}
            download={this.props.download}
            linkTo={this.props.linkTo}
            onClick={this.props.onClick}
            renderLink={this.props.renderLink}
            tabIndex={this.props.tabIndex}
            targetBlank={this.props.targetBlank}
          >
            {this.props.children}
          </CoreInteractive>
        </InjectLayout>
      </li>
    );
  }

  private get className() {
    const classes: ClassValue = {
      'tw-tab': true,
      'tw-tab--disabled': this.props.disabled,
    };

    return cn(classes);
  }
}
