import * as history from 'history';
import * as React from 'react';
import { CoreInteractiveProps } from '../../../../core-interactive';
import { CoreLink, CoreLinkType } from '../../../../core-link';
import { AlignItems, Display, InjectLayout, JustifyContent } from '../../../../layout';

export interface TabItemPublicProps {
  ariaLabel?: string;
  disabled?: boolean;
  label: string;
  linkTo?: history.LocationDescriptor;
  onClick?: (e: React.MouseEvent<HTMLElement>, index: number) => void;
  renderLink?: <P extends CoreInteractiveProps>(props: P) => React.ReactNode;
  tabIndex?: number;
  targetBlank?: boolean;
  title?: string;
}

export interface TabItemProps extends TabItemPublicProps {
  originalIndex: number;
}

export class TabItem extends React.Component<TabItemProps, {}> {

  public render() {
    return (
      <InjectLayout
        display={Display.Flex}
        alignItems={AlignItems.Center}
        padding={{ x : 2 }}
        fullHeight
        fullWidth
        justifyContent={JustifyContent.Center}
      >
        <CoreLink
          type={CoreLinkType.Inherit}
          hoverUnderlineNone
          onClick={this.handleTabOnClick}
          linkTo={this.props.linkTo}
          ariaLabel={this.props.ariaLabel}
          disabled={this.props.disabled}
          renderLink={this.props.renderLink}
          tabIndex={this.props.tabIndex}
          targetBlank={this.props.targetBlank}
          title={this.props.title}
        >
          {this.props.label}
        </CoreLink>
      </InjectLayout>
    );
  }

  private handleTabOnClick = (e: React.MouseEvent<HTMLElement>) => {
    if (this.props.onClick) {
      this.props.onClick(e, this.props.originalIndex);
    }
  }
}
