import * as React from 'react';
import { Interactable, InteractableType } from '../../../../interactable';
import { Layout } from '../../../../layout';
import { TabItemProps } from '../tab-item';

export interface TabMenuItemProps extends TabItemProps {
}

export class TabMenuItem extends React.Component<TabMenuItemProps, {}> {

  public render() {
    return (
      <Interactable
        type={InteractableType.Inverted}
        linkTo={this.props.linkTo}
        onClick={this.handleClick}
        ariaLabel={this.props.ariaLabel}
        disabled={this.props.disabled}
        renderLink={this.props.renderLink}
        tabIndex={this.props.tabIndex}
        targetBlank={this.props.targetBlank}
      >
        <Layout padding={{ x: 1, y: 0.5 }}>{this.props.label}</Layout>
      </Interactable>
    );
  }

  private handleClick = (e: React.MouseEvent<HTMLElement>) => {
    if (this.props.onClick) {
      this.props.onClick(e, this.props.originalIndex);
    }
  }
}
