import * as React from 'react';
import { Balloon, BalloonDirection } from '../../../../balloon';
import { TabItemProps } from '../tab-item';
import { TabMenuItem } from '../tab-menu-item';

export interface TabMenuProps {
  tabs: TabItemProps[];
}

export class TabMenu extends React.Component<TabMenuProps, {}> {
  public render() {
    return (
      <Balloon direction={BalloonDirection.BottomRight} show>
        <div>
          {this.props.tabs.map((tab, index) => (
            <TabMenuItem {...tab} key={index} />
          ))}
        </div>
      </Balloon>
    );
  }

}
