import { setupShallowTest } from '../../tests/helpers';
import { SVGAsset } from '../svg';
import {
  Tag,
  TagAction,
  TagProps,
  TagType,
} from './component';

function getRequiredProps(): TagProps {
  return {
    label: 'Test label',
  };
}

function getOptionalProps(): TagProps {
  return {
    disabled: true,
    label: 'Test label',
    onClick: jest.fn(),
    tabIndex: 0,
    ariaLabel: 'a link to something',
    autoFocus: true,
    blurAfterClick: true,
    download: 'download',
    linkTo: 'https://example.com',
    targetBlank: true,
    title: 'test title',
  };
}

const setupShallow = setupShallowTest(Tag, getRequiredProps);

describe('Tag', () => {
  it('renders tag component with only required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tag component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tag component with an icon', () => {
    const { wrapper } = setupShallow({ icon: SVGAsset.Gear });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tag component with type prop', () => {
    const { wrapper } = setupShallow({ type: TagType.Accent });
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tag component with an actionType prop', () => {
    const { wrapper } = setupShallow({ action: TagAction.Add });
    expect(wrapper).toMatchSnapshot();
  });
});
