import * as React from 'react';
import { cn } from '../../utils/classnames';
import { Interactable, InteractableType } from '../interactable';
import { AlignItems, Display, FlexWrap, JustifyContent, Layout } from '../layout';
import { Background, StyledLayout } from '../styled-layout';
import { SVG, SVGAsset } from '../svg';
import './styles.scss';

export interface ToastProps {
  children?: React.ReactNode;
  tabIndex?: number;
  /**
   * @example ()=>{ alert('Close Event Detected') }
   */
  onClose: React.MouseEventHandler<HTMLElement>;
}

export const Toast: React.SFC<ToastProps> = (props) => {
  const classes: ClassValue = {
    'tw-toast': true,
  };

  return (
    <Layout fullWidth>
      <StyledLayout display={Display.Flex} flexWrap={FlexWrap.NoWrap} className={cn(classes)} elevation={3} background={Background.Base} border>
        <Layout flexGrow={1}>
          {props.children}
        </Layout>
        <StyledLayout display={Display.Flex} flexShrink={0} borderLeft>
          <Interactable onClick={props.onClose} ariaLabel="Dismiss This" tabIndex={props.tabIndex} type={InteractableType.Alpha} data-a-target="tw-toast-close">
            <Layout padding={1} display={Display.Flex} alignItems={AlignItems.Center} justifyContent={JustifyContent.Center} className="tw-toast__dismiss-target">
              <SVG asset={SVGAsset.Close} />
            </Layout>
          </Interactable>
        </StyledLayout>
      </StyledLayout>
    </Layout>
  );
};

Toast.displayName = 'Toast';
