import { setupShallowTest } from '../../tests/helpers';
import { Display } from '../layout';
import {
  Tooltip,
  TooltipAlign,
  TooltipDirection,
  TooltipProps,
} from './component';

function getRequiredProps(): TooltipProps {
  return {
    label: 'Test label',
    id: 'test-id',
  };
}

function getOptionalProps(): TooltipProps {
  return {
    align: TooltipAlign.Center,
    direction: TooltipDirection.Left,
    display: Display.Inline,
    label: 'Test label',
    id: 'test-id',
    show: true,
    width: 100,
    offsetX: '-20px',
    offsetY: '-20px',
    title: 'Test title',
  };
}

const setupShallow = setupShallowTest(Tooltip);

describe('Tooltip', () => {
  it('renders tooltip component with only required props', () => {
    const { wrapper } = setupShallow(getRequiredProps());
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tooltip component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
