import { setupShallowTest } from '../../tests/helpers';
import {
  Tower,
  TowerChildWidth,
  TowerGutter,
  TowerProps,
} from './component';

function getOptionalProps(): TowerProps {
  return {
    center: true,
    childWidth: TowerChildWidth.Medium,
    gutterSize: TowerGutter.ExtraSmall,
    noGrow: true,
    noWrap: true,
    placeholderItems: 10,
  };
}

const setupShallow = setupShallowTest(Tower);

describe('Tower', () => {
  it('renders tower component with only required props', () => {
    const { wrapper } = setupShallow();
    expect(wrapper).toMatchSnapshot();
  });

  it('renders tower component with all props', () => {
    const { wrapper } = setupShallow(getOptionalProps());
    expect(wrapper).toMatchSnapshot();
  });
});
