import * as React from 'react';
import { cn } from '../../utils/classnames';
import { getDataProps } from '../../utils/data-props';
import { FontSize } from '../core-text';
import { StyledLayout } from '../styled-layout';
import './styles.scss';

export interface TypesetProps {
  /**
   * The font size for body text, as well as `<p>`, `<code>`, `<li>`, and
   * `<code>`.
   */
  baseFontSize?: FontSize;
  /**
   * The markup to be formatted.
   *
   * @example <h1>Join us for TwitchCon Developer Day!</h1>
   */
  children?: React.ReactNode;
}

/**
 * A component wrapper to use for a set of styled text markup. This component
 * provides a sane set of styling rules to common text elements, including
 * `<h1>`, `<h2>`, `<h3>`, `<h4>`, `<h5>`, `<h6>`, `<p>`, `<ul>`, `<ol>`,
 * `<code>`, `<pre>`, `<blockquote>`, and `<hr>`.
 */
export const Typeset: React.SFC<TypesetProps> = (props) => {
  const classes: ClassValue = {
    'tw-typeset': true,
  };

  return (
    <StyledLayout
      className={cn(classes)}
      fontSize={props.baseFontSize || FontSize.Size5}
      {...getDataProps(props)}
    >
      {props.children}
    </StyledLayout>
  );
};

Typeset.displayName = 'Typeset';
