import * as React from 'react';
import { BorderRadius, Display, InjectLayout, InjectStyledLayout, Overflow } from '../../..';
import './styles.scss';

export interface Props {
  children: React.ReactNode;
}

interface State {
}

export class CodeSnippet extends React.Component<Props, State> {
  public render() {
    return (
      <InjectStyledLayout display={Display.InlineFlex} overflow={Overflow.Hidden} borderRadius={BorderRadius.Medium}>
        <code className="code-snippet">
          <InjectLayout overflow={Overflow.Auto} padding={3}>
            <pre className="code-snippet__pre">
              {this.props.children}
            </pre>
          </InjectLayout>
        </code>
      </InjectStyledLayout>
    );
  }
}
