import * as React from 'react';
import { Toggle } from '../../../index';

interface Props {
  feature: string;
  rootPrefix?: string;
}

interface State {
  featureActive: boolean;
}

export class FeatureToggle extends React.Component<Props, State> {

  public constructor(props: Props) {
    super(props);

    this.state = {
      featureActive: !!localStorage.getItem(this.props.feature),
    };
  }

  public componentDidMount () {
    this.updateRootSelectorClass();
  }

  public componentDidUpdate ({}, prevState: State) {
    if (prevState.featureActive !== this.state.featureActive) {
      this.updateRootSelectorClass();
    }
  }

  public render() {
    return <Toggle onChange={this.toggleActiveState} checked={this.state.featureActive} />;
  }

  private toggleActiveState = () => {
    this.setState({ featureActive: !this.state.featureActive });
  }

  private updateRootSelectorClass = () => {
    const target = document.body;
    const classValue = `${this.props.rootPrefix || 'tw-root--'}${this.props.feature}`;

    if (!target) { return; }

    if (this.state.featureActive) {
      target.classList.add(classValue);
      localStorage.setItem(this.props.feature, 'true');
    } else {
      target.classList.remove(classValue);
      localStorage.removeItem(this.props.feature);
    }
  }
}
