import { AboutPage } from '../../pages/about';
import { AlertBannerPage } from '../../pages/alert-banner';
// import { AnimationPage } from '../../pages/animation';
// import { AspectPage } from '../../pages/aspect';
import { AvatarPage } from '../../pages/avatar';
import { BadgePage } from '../../pages/badge/component';
// import { BalloonPage } from '../../pages/balloon';
import { ButtonPage } from '../../pages/button';
import { ButtonIconPage } from '../../pages/button-icon';
import { ChannelStatusIndicatorPage } from '../../pages/channel-status-indicator';
import { CoreTextPage } from '../../pages/core-text';
// import { ToastPage } from '../../pages/toast';
// import { TooltipPage } from '../../pages/tooltip';
// import { TowerPage } from '../../pages/tower';
// import { TypesetPage } from '../../pages/typeset';
// import { CoreImagePage } from '../../pages/core-image';
// import { CoreInteractivePage } from '../../pages/core-interactive';
// import { CoreLinkPage } from '../../pages/core-link';
// import { DropZonePage } from '../../pages/drop-zone';
import { DropDownMenuPage } from '../../pages/drop-down-menu';
import { EditorialDetailPage } from '../../pages/editorial-detail';
import { InFeatureNotificationPage } from '../../pages/in-feature-notification';
import { LoadingSpinnerPage } from '../../pages/loading-spinner';
import { PillPage } from '../../pages/pill';
// import { GridPage } from '../../pages/grid';
// import { InteractablePage } from '../../pages/interactable';
// import { LayoutPage } from '../../pages/layout';
import { PresencePage } from '../../pages/presence';
// import { PlaceholderPage } from '../../pages/placeholder';
import { ProgressBarPage } from '../../pages/progress-bar';
import { StatPage } from '../../pages/stat';
// import { ResponsiveWrapperPage } from '../../pages/responsive-wrapper';
import { StyledLayoutPage } from '../../pages/styled-layout';
import { SVGPage } from '../../pages/svg';
import { TabsPage } from '../../pages/tabs';
import { TagPage } from '../../pages/tag';

// Sub Pages

// import { AccordionBodyPage } from '../../pages/accordion/accordion-body';
// import { AccordionFooterPage } from '../../pages/accordion/accordion-footer';
// import { AccordionHeaderPage } from '../../pages/accordion/accordion-header';

// import { CardBodyPage } from '../../pages/card/card-body';
// import { CardImagePage } from '../../pages/card/card-image';
// import { BoxArtCardPage } from '../../pages/card/composed-cards/box-art-card';
// import { ThumbnailCardPage } from '../../pages/card/composed-cards/thumbnail-card';

import { FormCheckboxPage } from '../../pages/form/checkbox';
import { FormGroupPage } from '../../pages/form/form-group';
import { FormInputPage } from '../../pages/form/input';
import { FormRadioPage } from '../../pages/form/radio';
import { FormRangePage } from '../../pages/form/range';
import { FormSearchInputPage } from '../../pages/form/search-input';
// import { FormSegmentedButtonPage } from '../../pages/form/segmented-button';
import { FormSelectPage } from '../../pages/form/select';
import { FormTextareaPage } from '../../pages/form/textarea';
import { FormTogglePage } from '../../pages/form/toggle';

export interface NavItem {
  name: string;
  linkTo?: string;
  links?: NavItem[];
  exact?: boolean;
  component?: React.ComponentType;
}

const ROUTE_PATH = '/components/';

export const PageIndex: NavItem[] = [
  {
    name: 'Index',
    links: [
      { name: 'About', component: AboutPage, linkTo: `/`, exact: true },
    ],
  },
  {
    name: 'Components',
    links: [
      // {
      //   name: 'Accordion',
      //   linkTo: `${ROUTE_PATH}accordion`,
      //   links: [
      //     { name: 'AccordionBody', component: AccordionBodyPage, linkTo: `${ROUTE_PATH}accordion/accordion-body` },
      //     { name: 'AccordionFooter', component: AccordionFooterPage, linkTo: `${ROUTE_PATH}accordion/accordion-footer` },
      //     { name: 'AccordionHeader', component: AccordionHeaderPage, linkTo: `${ROUTE_PATH}accordion/accordion-header` },
      //   ],
      // },
      { name: 'AlertBanner', component: AlertBannerPage, linkTo: `${ROUTE_PATH}alert-banner` },
      // { name: 'Animation', component: AnimationPage, linkTo: `${ROUTE_PATH}animation` },
      // { name: 'Aspect', component: AspectPage, linkTo: `${ROUTE_PATH}aspect` },
      { name: 'Avatar', component: AvatarPage, linkTo: `${ROUTE_PATH}avatar` },
      { name: 'Badge', component: BadgePage, linkTo: `${ROUTE_PATH}badge` },
      // { name: 'Balloon', component: BalloonPage, linkTo: `${ROUTE_PATH}balloon` },
      { name: 'Button', component: ButtonPage, linkTo: `${ROUTE_PATH}button` },
      { name: 'ButtonIcon', component: ButtonIconPage, linkTo: `${ROUTE_PATH}button-icon` },
      // {
      //   name: 'Card',
      //   linkTo: `${ROUTE_PATH}card`,
      //   links: [
      //     { name: 'CardImage', component: CardImagePage, linkTo: `${ROUTE_PATH}card/card-image` },
      //     { name: 'CardBody', component: CardBodyPage, linkTo: `${ROUTE_PATH}card/card-body` },
      //     {
      //       name: 'Composed Cards',
      //       linkTo: `${ROUTE_PATH}composed-cards`,
      //       links: [
      //         { name: 'Box At Card', component: BoxArtCardPage, linkTo: `${ROUTE_PATH}card/composed-cards/box-art-card` },
      //         { name: 'Thumbnail Card', component: ThumbnailCardPage, linkTo: `${ROUTE_PATH}card/composed-cards/thumbnail-card` },
      //       ],
      //     },
      //   ],
      // },
      { name: 'ChannelStatusIndicator', component: ChannelStatusIndicatorPage, linkTo: `${ROUTE_PATH}channel-status-indicator` },
      // { name: 'CoreImage', component: CoreImagePage, linkTo: `${ROUTE_PATH}core-image` },
      // { name: 'CoreInteractive', component: CoreInteractivePage, linkTo: `${ROUTE_PATH}core-interactive` },
      // { name: 'CoreLink', component: CoreLinkPage, linkTo: `${ROUTE_PATH}core-link` },
      { name: 'CoreText', component: CoreTextPage, linkTo: `${ROUTE_PATH}core-text` },
      // { name: 'DropZone', component: DropZonePage, linkTo: `${ROUTE_PATH}drop-zone` },
      { name: 'DropDownMenu', component: DropDownMenuPage, linkTo: `${ROUTE_PATH}drop-down-menu` },
      { name: 'EditorialDetail', component: EditorialDetailPage, linkTo: `${ROUTE_PATH}editorial-detail` },
      {
        name: 'Form',
        linkTo: `${ROUTE_PATH}form`,
        links: [
          { name: 'Checkbox', component: FormCheckboxPage, linkTo: `${ROUTE_PATH}form/checkbox` },
          { name: 'FormGroup', component: FormGroupPage, linkTo: `${ROUTE_PATH}form/form-group` },
          { name: 'Input', component: FormInputPage, linkTo: `${ROUTE_PATH}form/input` },
          { name: 'Radio', component: FormRadioPage, linkTo: `${ROUTE_PATH}form/radio` },
          { name: 'Range', component: FormRangePage, linkTo: `${ROUTE_PATH}form/range` },
          { name: 'SearchInput', component: FormSearchInputPage, linkTo: `${ROUTE_PATH}form/search-input` },
          // { name: 'Segmented Button', component: FormSegmentedButtonPage, linkTo: `${ROUTE_PATH}form/segmented-button` },
          { name: 'Select', component: FormSelectPage, linkTo: `${ROUTE_PATH}form/select` },
          { name: 'Textarea', component: FormTextareaPage, linkTo: `${ROUTE_PATH}form/textarea` },
          { name: 'Toggle', component: FormTogglePage, linkTo: `${ROUTE_PATH}form/toggle` },
        ],
      },
      // { name: 'Grid', component: GridPage, linkTo: `${ROUTE_PATH}grid` },
      { name: 'InFeatureNotification', component: InFeatureNotificationPage, linkTo: `${ROUTE_PATH}in-feature-notification` },
      // { name: 'Interactable', component: InteractablePage, linkTo: `${ROUTE_PATH}interactable` },
      // { name: 'Layout', component: LayoutPage, linkTo: `${ROUTE_PATH}layout` },
      { name: 'Loading Spinner', component: LoadingSpinnerPage, linkTo: `${ROUTE_PATH}loading-spinner` },
      { name: 'Pill', component: PillPage, linkTo: `${ROUTE_PATH}pill` },
      // { name: 'Placeholder', component: PlaceholderPage, linkTo: `${ROUTE_PATH}placeholder` },
      { name: 'Presence', component: PresencePage, linkTo: `${ROUTE_PATH}presence` },
      { name: 'ProgressBar', component: ProgressBarPage, linkTo: `${ROUTE_PATH}progress-bar` },
      // { name: 'ResponsiveWrapper', component: ResponsiveWrapperPage, linkTo: `${ROUTE_PATH}responsive-wrapper` },
      { name: 'Stat', component: StatPage, linkTo: `${ROUTE_PATH}stat` },
      { name: 'StyledLayout', component: StyledLayoutPage, linkTo: `${ROUTE_PATH}styled-layout` },
      { name: 'SVG', component: SVGPage, linkTo: `${ROUTE_PATH}svg` },
      { name: 'Tabs', component: TabsPage, linkTo: `${ROUTE_PATH}tabs` },
      { name: 'Tag', component: TagPage, linkTo: `${ROUTE_PATH}tag` },
      // { name: 'Toast', component: ToastPage, linkTo: `${ROUTE_PATH}toast` },
      // { name: 'Tooltip', component: TooltipPage, linkTo: `${ROUTE_PATH}tooltip` },
      // { name: 'Tower', component: TowerPage, linkTo: `${ROUTE_PATH}tower` },
      // { name: 'Typeset', component: TypesetPage, linkTo: `${ROUTE_PATH}typeset` },
    ],
  },
];
