import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { HashRouter } from 'react-router-dom';
import { Background, Color, Display, Position, StyledLayout } from '../index';
import { MainNav, MainRoutes } from './components/navigation';
import './main.scss';

const root = (
  <HashRouter>
    <StyledLayout
      background={Background.Base}
      color={Color.Base}
      fullHeight
      fullWidth
      position={Position.Absolute}
      attachBottom
      attachLeft
      attachRight
      attachTop
      display={Display.Flex}
    >
      <MainNav />
      <MainRoutes />
    </StyledLayout>
  </HashRouter>
);

const rootElement = document.createElement('div');
document.body.appendChild(rootElement);
ReactDOM.render(root, rootElement);
