import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Color, CoreText, Display, InjectLayout, Layout, TextType } from '../../../index';
import image from '../../assets/images/component_generator_example.png';
import { CodeSnippet } from '../../components/code-snippet';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class AboutPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout fullWidth>
        <Layout margin={{ bottom: 3 }}>
          <CoreText type={TextType.H2}>About</CoreText>
          <CoreText type={TextType.H6} color={Color.Alt2}>A breif overview of the Combination Generator</CoreText>
        </Layout>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H4}>What is the Component Generator?</CoreText>
          <CoreText>The Component Generator is a component made to help generate out all visual permentations of a Core UI component.</CoreText>
        </Layout>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H4}>Why use the Component Generator?</CoreText>
          <CoreText>The Component Generator gives us an easy way to measure and test visual changes to Core UI, whether this testing be manual or automated.</CoreText>
        </Layout>
        <Layout margin={{ bottom: 2 }}>
          <Layout margin={{ bottom: 1 }}>
            <CoreText type={TextType.H4}>How does the Component Generator work?</CoreText>
            <CoreText>The Component Generator uses a set of field props to define a vertical pattern to be iteratored over. The generator also takes set of children with custom props to be iterated over in a horizontal pattern.</CoreText>
          </Layout>
          <Layout display={Display.Flex}>
            <Layout margin={{ bottom: 1, right: 2 }}>
              <CoreText bold>Example:</CoreText>
              <CodeSnippet>
{`<CombinationGenerator
  fields={[
    {
      propKey: 'fullWidth',
      propValues: [false, true],
    },
    {
      propKey: 'disabled',
      propValues: [false, true],
    },
    {
      propKey: 'size',
      propValues: [ButtonSize.Default, ButtonSize.Large, ButtonSize.Small],
    },
    {
      propKey: 'dropdown',
      propValues: [false, true],
    },
    {
      propKey: 'purchase',
      propValues: [undefined, '$4.99'],
    },
    {
      propKey: 'icon',
      propValues: [undefined, SVGAsset.LogoGlitch],
    },
  ]}
>
  <Button {...additionalProps} type={ButtonType.Default}>Hello World</Button>
  <Button {...additionalProps} type={ButtonType.Success}>Hello World</Button>
  <Button {...additionalProps} type={ButtonType.Alert}>Hello World</Button>
  <Button {...additionalProps} type={ButtonType.Hollow}>Hello World</Button>
  <Button {...additionalProps} type={ButtonType.Text}>Hello World</Button>
</CombinationGenerator>`}
              </CodeSnippet>
            </Layout>
            <Layout margin={{ bottom: 1 }}>
              <CoreText bold>Output:</CoreText>
              <InjectLayout fullWidth>
                <img src={image} style={{ maxWidth: 918 }} />
              </InjectLayout>
            </Layout>
          </Layout>
        </Layout>
      </Layout>
    );
  }
}
