import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { AlertBanner, AlertBannerProps, AlertBannerType, CoreText, Layout, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class AlertBannerPage extends React.Component<Props, {}> {
  public render() {
    return (
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>AlertBanner Examples</CoreText>
          {this.renderExamples()}
        </Layout>
    );
  }

  private onCloseButtonClick = () => {
    alert('Close!');
  }

  private renderExamples = () => {
    const requireProps: AlertBannerProps = {
      closeButtonAriaLabel: 'Close',
      message: '',
      type: AlertBannerType.Error,
      onCloseButtonClick: this.onCloseButtonClick,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'type',
            propValues: [AlertBannerType.Error, AlertBannerType.Info, AlertBannerType.Success, AlertBannerType.Warning],
          },
          {
            propKey: 'status',
            propValues: [undefined, 'Status Message'],
          },
          {
            propKey: 'message',
            propValues: ['Message text.', 'Donec auctor massa sit amet enim auctor, eu sollicitudin mauris imperdiet. Aenean sed lorem diam. Integer semper nibh ac metus dictum, a dictum massa eleifend. Nunc risus mi, sollicitudin sit amet aliquet eu, efficitur sit amet massa. Proin mattis justo quam, eu porta augue venenatis a. Phasellus blandit urna vel tellus euismod hendrerit. Nam ut augue lectus. Etiam metus augue, vehicula at justo vitae, placerat pulvinar arcu. Pellentesque ultrices nisi quis finibus eleifend.'],
          },
          {
            propKey: 'link',
            propValues: [undefined, { to: '/', children: 'Link Item' }],
          },
        ]}
      >
        <AlertBanner {...requireProps} />
      </CombinationGenerator>
    );
  }
}
