import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Avatar, AvatarProps, BorderRadius, CoreText, Layout, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class AvatarPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Avatar Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: AvatarProps = {
      alt: 'Avatar',
      size: 30,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [30, 36, 40, 50, 64, 80, 96, 300],
          },
        ]}
      >
        <Avatar {...requireProps} borderRadius={BorderRadius.None} />
        <Avatar {...requireProps} borderRadius={BorderRadius.Small} />
        <Avatar {...requireProps} borderRadius={BorderRadius.Medium} />
        <Avatar {...requireProps} borderRadius={BorderRadius.Large} />
        <Avatar {...requireProps} borderRadius={BorderRadius.Rounded} />
      </CombinationGenerator>
    );
  }
}
