import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Badge, BadgeProps, BadgeType, CoreText, Layout, SVGAsset, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class BadgePage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Badge Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: BadgeProps = {
      icon: SVGAsset.Heart,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [24, 40, 80, 120],
          },
          {
            propKey: 'icon',
            propValues: [SVGAsset.Heart, SVGAsset.Friends, SVGAsset.Experiment],
          },
        ]}
      >
        <Badge {...requireProps} type={BadgeType.Alt} />
        <Badge {...requireProps} type={BadgeType.Alt2} />
        <Badge {...requireProps} type={BadgeType.Brand} />
        <Badge {...requireProps} type={BadgeType.Dashboard} />
        <Badge {...requireProps} type={BadgeType.Prime} />
        <Badge {...requireProps} type={BadgeType.Success} />
        <Badge {...requireProps} type={BadgeType.Alert} />
        <Badge {...requireProps} type={BadgeType.Live} />
        <Badge {...requireProps} type={BadgeType.Notification} />
      </CombinationGenerator>
    );
  }
}
