import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Background, ButtonIcon, ButtonIconProps, ButtonIconSize, ButtonIconType, Color, CoreText, Layout, StyledLayout, SVGAsset, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class ButtonIconPage extends React.Component<Props, {}> {
  public render() {
    return (
      <div>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>ButtonIcon Examples</CoreText>
          {this.renderExamples()}
        </Layout>

        <StyledLayout padding={2} background={Background.AccentAlt} color={Color.Overlay}>
          <CoreText type={TextType.H2} color={Color.Inherit}>ButtonIcon Overlay Examples</CoreText>
          {this.renderExamples({ overlay: true, icon: SVGAsset.LogoGlitch, ariaLabel: 'button' })}
        </StyledLayout>
      </div>
    );
  }

  private renderExamples = (additionalProps: ButtonIconProps = { icon: SVGAsset.LogoGlitch, ariaLabel: 'button' }) => (
    <CombinationGenerator
      fields={[
        {
          propKey: 'disabled',
          propValues: [false, true],
        },
        {
          propKey: 'size',
          propValues: [ButtonIconSize.Default, ButtonIconSize.Large, ButtonIconSize.Small],
        },
        {
          propKey: 'icon',
          propValues: [SVGAsset.LogoGlitch],
        },
        {
          propKey: 'statusAlertIcon',
          propValues: [undefined, SVGAsset.Heart],
        },
      ]}
    >
      <ButtonIcon {...additionalProps} type={ButtonIconType.Default}>Hello World</ButtonIcon>
      <ButtonIcon {...additionalProps} type={ButtonIconType.Success}>Hello World</ButtonIcon>
      <ButtonIcon {...additionalProps} type={ButtonIconType.Alert}>Hello World</ButtonIcon>
      <ButtonIcon {...additionalProps} type={ButtonIconType.Hollow}>Hello World</ButtonIcon>
      <ButtonIcon {...additionalProps} type={ButtonIconType.Primary}>Hello World</ButtonIcon>
      <ButtonIcon {...additionalProps} type={ButtonIconType.Secondary}>Hello World</ButtonIcon>
    </CombinationGenerator>
  )
}
