import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Background, Button, ButtonProps, ButtonSize, ButtonType, Color, CoreText, Layout, StyledLayout, SVGAsset, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class ButtonPage extends React.Component<Props, {}> {
  public render() {
    return (
      <div>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>Button Examples</CoreText>
          {this.renderExamples()}
        </Layout>

        <StyledLayout padding={2} background={Background.AccentAlt} color={Color.Overlay}>
          <CoreText type={TextType.H2} color={Color.Inherit}>Button Overlay Examples</CoreText>
          {this.renderExamples({ overlay: true })}
        </StyledLayout>
      </div>
    );
  }

  private renderExamples = (additionalProps: ButtonProps = {}) => (
    <CombinationGenerator
      fields={[
        {
          propKey: 'fullWidth',
          propValues: [false, true],
        },
        {
          propKey: 'disabled',
          propValues: [false, true],
        },
        {
          propKey: 'size',
          propValues: [ButtonSize.Default, ButtonSize.Large, ButtonSize.Small],
        },
        {
          propKey: 'dropdown',
          propValues: [false, true],
        },
        {
          propKey: 'purchase',
          propValues: [undefined, '$4.99'],
        },
        {
          propKey: 'icon',
          propValues: [undefined, SVGAsset.LogoGlitch],
        },
      ]}
    >
      <Button {...additionalProps} type={ButtonType.Default}>Hello World</Button>
      <Button {...additionalProps} type={ButtonType.Success}>Hello World</Button>
      <Button {...additionalProps} type={ButtonType.Alert}>Hello World</Button>
      <Button {...additionalProps} type={ButtonType.Hollow}>Hello World</Button>
      <Button {...additionalProps} type={ButtonType.Text}>Hello World</Button>
    </CombinationGenerator>
  )
}
