import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { ChannelStatusIndicator, ChannelStatusIndicatorSize, ChannelStatusIndicatorStatus, CoreText, Layout, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class ChannelStatusIndicatorPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>ChannelStatusIndicator Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'status',
            propValues: [ChannelStatusIndicatorStatus.Offline, ChannelStatusIndicatorStatus.Hosting, ChannelStatusIndicatorStatus.Live],
          },
          {
            propKey: 'size',
            propValues: [ChannelStatusIndicatorSize.Small, ChannelStatusIndicatorSize.Medium, ChannelStatusIndicatorSize.Large],
          },
        ]}
      >
        <ChannelStatusIndicator />
        <ChannelStatusIndicator pulse />
      </CombinationGenerator>
    );
  }
}
