import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Color, CoreText, FontSize, Layout, TextDecoration, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class CoreTextPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>CoreText Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'bold',
            propValues: [false, true],
          },
          {
            propKey: 'italic',
            propValues: [false, true],
          },
          {
            propKey: 'decoration',
            propValues: [undefined, TextDecoration.Strikethrough, TextDecoration.Underline],
          },
          {
            propKey: 'fontSize',
            propValues: [undefined, FontSize.Size1, FontSize.Size2, FontSize.Size3, FontSize.Size4, FontSize.Size5, FontSize.Size6, FontSize.Size7, FontSize.Size8],
          },
          {
            propKey: 'color',
            propValues: [Color.Inherit, Color.Alt, Color.Alt2, Color.Error, Color.Link, Color.Live, Color.Overlay, Color.OverlayAlt],
          },
        ]}
      >
        <CoreText type={TextType.P}>Prargraph Text</CoreText>
        <CoreText type={TextType.Span}>Span Text</CoreText>
        <CoreText type={TextType.Em}>Em Text</CoreText>
        <CoreText type={TextType.H1}>H1 Text</CoreText>
        <CoreText type={TextType.H2}>H2 Text</CoreText>
        <CoreText type={TextType.H3}>H3 Text</CoreText>
        <CoreText type={TextType.H4}>H4 Text</CoreText>
        <CoreText type={TextType.H5}>H5 Text</CoreText>
        <CoreText type={TextType.H6}>H6 Text</CoreText>
        <CoreText type={TextType.Strong}>Strong Text</CoreText>
      </CombinationGenerator>
    );
  }
}
