import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { BalloonSize } from '../../..';
import { AspectRatio } from '../../../components/aspect';
import { CoreText, TextType } from '../../../components/core-text';
import { DropDownMenu } from '../../../components/drop-down-menu/drop-down-menu';
import { DropDownMenuInputItemType } from '../../../components/drop-down-menu/drop-down-menu-input-item';
import { Layout, Position } from '../../../components/layout';
import { SVGAsset } from '../../../components/svg';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class DropDownMenuPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }} fullWidth>
        <CoreText type={TextType.H2}>DropDownMenu</CoreText>
          <CombinationGenerator
            fields={[
              {
                propKey: 'size',
                propValues: [BalloonSize.Small],
              },
            ]}
          >
            <div style={{ height: 500 }}>
              <Layout position={Position.Relative}>
                <DropDownMenu
                  items={[
                    { title: 'About', linkTo: '#' },
                    { title: 'Ad Choices' },
                    { title: 'Advertisers' },
                    { title: 'Blog' },
                    { title: 'Community Guidelines' },
                    { title: 'Cookie Policy' },
                    { title: 'Creative' },
                    { title: 'Developers' },
                    { title: 'Help' },
                    { title: 'Jobs' },
                    { title: 'Language' },
                    { title: 'Music' },
                    { title: 'Partners' },
                    { title: 'Press' },
                    { title: 'Privacy Policy' },
                    { title: 'Security' },
                    { title: 'Terms' },
                  ]}
                  elevation={3}
                  show
                />
              </Layout>
            </div>
            <div>
              <div style={{ height: 190 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      {
                        title: 'Aatrox',
                        figure: {
                          alt: 'Aatrox avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Aatrox.png',
                        },
                      },
                      {
                        title: 'Ashe',
                        figure: {
                          alt: 'Ashe avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Ashe.png',
                        },
                      },
                      {
                        title: 'Caitlyn',
                        figure: {
                          alt: 'Caitlyn avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Caitlyn.png',
                        },
                      },
                      {
                        title: 'Dr. Mundo',
                        figure: {
                          alt: 'Dr. Mundo avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/DrMundo.png',
                        },
                      },
                      {
                        title: 'Fiora',
                        figure: {
                          alt: 'Fiora avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Fiora.png',
                        },
                      },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <div style={{ height: 190 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      {
                        title: 'Aatrox',
                        figure: {
                          alt: 'Aatrox avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Aatrox.png',
                        },
                        figureRight: true,
                      },
                      {
                        title: 'Ashe',
                        figure: {
                          alt: 'Ashe avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Ashe.png',
                        },
                        figureRight: true,
                      },
                      {
                        title: 'Caitlyn',
                        figure: {
                          alt: 'Caitlyn avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Caitlyn.png',
                        },
                        figureRight: true,
                      },
                      {
                        title: 'Dr. Mundo',
                        figure: {
                          alt: 'Dr. Mundo avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/DrMundo.png',
                        },
                        figureRight: true,
                      },
                      {
                        title: 'Fiora',
                        figure: {
                          alt: 'Fiora avatar',
                          src: 'https://ddragon.leagueoflegends.com/cdn/8.17.1/img/champion/Fiora.png',
                        },
                        figureRight: true,
                      },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <Layout position={Position.Relative}>
                <DropDownMenu
                  items={[
                    {
                      title: 'Fortnite',
                      figure: {
                        alt: 'Fortnite box art',
                        src: 'https://static-cdn.jtvnw.net/ttv-boxart/Fortnite-285x380.jpg',
                      },
                      figureAspectRatio: AspectRatio.Aspect3x4,
                    },
                    {
                      title: 'League of Legends',
                      figure: {
                        alt: 'League of Legends box art',
                        src: 'https://static-cdn.jtvnw.net/ttv-boxart/League%20of%20Legends-285x380.jpg',
                      },
                      figureAspectRatio: AspectRatio.Aspect3x4,
                    },
                    {
                      title: 'Overwatch',
                      figure: {
                        alt: 'Overwatch box art',
                        src: 'https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-285x380.jpg',
                      },
                      figureAspectRatio: AspectRatio.Aspect3x4,
                    },
                    {
                      title: 'Hearthstone',
                      figure: {
                        alt: 'Hearthstone box art',
                        src: 'https://static-cdn.jtvnw.net/ttv-boxart/Hearthstone-285x380.jpg',
                      },
                      figureAspectRatio: AspectRatio.Aspect3x4,
                    },
                  ]}
                  show
                />
              </Layout>
            </div>
            <div>
              <div style={{ height: 132 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      {
                        title: 'Games',
                        figure: SVGAsset.NavGames,
                      },
                      {
                        title: 'Channels',
                        figure: SVGAsset.NavChannels,
                      },
                      {
                        title: 'Creative',
                        figure: SVGAsset.NavCreative,
                      },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <Layout position={Position.Relative}>
                <DropDownMenu
                  items={[
                    {
                      title: 'Games',
                      figure: SVGAsset.NavGames,
                      figureRight: true,
                    },
                    {
                      title: 'Channels',
                      figure: SVGAsset.NavChannels,
                      figureRight: true,
                    },
                    {
                      title: 'Creative',
                      figure: SVGAsset.NavCreative,
                      figureRight: true,
                    },
                  ]}
                  show
                />
              </Layout>
            </div>

            <Layout position={Position.Relative}>
              <DropDownMenu
                maxHeight="40vh"
                items={[
                  { label: 'English', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Dansk', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Deutsch', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Español', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Français', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Italiano', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Magyar', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Nederlands', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Norsk', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Polski', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Português', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Română', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Slovenčina', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Suomi', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Svenska', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Tiếng Việt', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Türkçe', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Čeština', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Ελληνικά', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Български', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'Русский', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'العربية', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: 'ภาษาไทย', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: '中文', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: '中文(粵語)', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: '日本語', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                  { label: '한국어', type: DropDownMenuInputItemType.CheckBox, name: 'language-select' },
                ]}
                show
              />
            </Layout>
            <div>
              <div style={{ height: 124 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      { label: 'PS4', type: DropDownMenuInputItemType.CheckBox, name: 'console' },
                      { label: 'Xbox', type: DropDownMenuInputItemType.CheckBox, name: 'console' },
                      { label: 'PC', type: DropDownMenuInputItemType.CheckBox, name: 'console' },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <div style={{ height: 128 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      { label: 'PS4', type: DropDownMenuInputItemType.CheckBox, name: 'console', icon: SVGAsset.NavGames },
                      { label: 'Xbox', type: DropDownMenuInputItemType.CheckBox, name: 'console', icon: SVGAsset.NavGames },
                      { label: 'PC', type: DropDownMenuInputItemType.CheckBox, name: 'console', icon: SVGAsset.NavGames },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <div style={{ height: 124 }}>
                <Layout position={Position.Relative}>
                  <DropDownMenu
                    items={[
                      { label: 'PS4', type: DropDownMenuInputItemType.Radio, name: 'console' },
                      { label: 'Xbox', type: DropDownMenuInputItemType.Radio, name: 'console' },
                      { label: 'PC', type: DropDownMenuInputItemType.Radio, name: 'console' },
                    ]}
                    show
                  />
                </Layout>
              </div>
              <Layout position={Position.Relative}>
                <DropDownMenu
                  items={[
                    { label: 'PS4', type: DropDownMenuInputItemType.Radio, name: 'console', icon: SVGAsset.NavGames },
                    { label: 'Xbox', type: DropDownMenuInputItemType.Radio, name: 'console', icon: SVGAsset.NavGames },
                    { label: 'PC', type: DropDownMenuInputItemType.Radio, name: 'console', icon: SVGAsset.NavGames },
                  ]}
                  show
                />
              </Layout>
            </div>
          </CombinationGenerator>
      </Layout>
    );
  }
}
