import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Background, CoreText, EditorialDetail, EditorialDetailProps, Layout, TextType } from '../../../index';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class EditorialDetailPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Editorial Detail Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: EditorialDetailProps = {
      title: 'Get this brand new offer',
      backgroundColor: Background.Accent,
    };

    return (
      <EditorialDetail {...requireProps} />
    );
  }
}
