import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CheckBox, CheckBoxProps, CoreText, InputSize, Layout, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormCheckboxPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Checkbox Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requiredProps: CheckBoxProps = {
      label: 'Checkbox Label',
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'checked',
            propValues: [undefined, false, true],
          },
          {
            propKey: 'disabled',
            propValues: [false, true],
          },
          {
            propKey: 'error',
            propValues: [false, true],
          },
          {
            propKey: 'readOnly',
            propValues: [false, true],
          },
          {
            propKey: 'required',
            propValues: [false, true],
          },
        ]}
      >
        <CheckBox {...requiredProps} />
        <CheckBox {...requiredProps} size={InputSize.Large} />
      </CombinationGenerator>
    );
  }
}
