import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, FormGroup, FormGroupOrientation, FormGroupProps, Input, InputType, Layout, Radio, Range, TextArea, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormGroupPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>FormGroup Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requiredProps: FormGroupProps = {
      label: 'Form Group Label',
      errorMessage: 'OMG, You did something wrong.',
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
          {
            propKey: 'label',
            propValues: ['Form Group Label', 'EXPERIMENT_TWILIGHT_ID_TRANSFORM_CHANNEL_PAGE'],
          },
          {
            propKey: 'labelOptional',
            propValues: [undefined, 'This is an optional label'],
          },
          {
            propKey: 'hint',
            propValues: [undefined, 'Hint copy to explain how to fill out this form'],
          },
          {
            propKey: 'orientation',
            propValues: [FormGroupOrientation.Vertical, FormGroupOrientation.Horizontal],
          },
        ]}
      >
        <FormGroup {...requiredProps}>
          <Input type={InputType.Text} />
        </FormGroup>
        <FormGroup {...requiredProps}>
          <Radio name="settings-pizza" label="Vegetarian" />
          <Radio name="settings-pizza" label="Pepperoni delux" />
          <Radio name="settings-pizza" label="Pineapple and ham supreme" />
        </FormGroup>
        <FormGroup {...requiredProps}>
          <Range />
        </FormGroup>
        <FormGroup {...requiredProps}>
          <TextArea />
        </FormGroup>
      </CombinationGenerator>
    );
  }
}
