import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Input, InputProps, InputSize, InputType, Layout, SVGAsset, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormInputPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Input Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requiredProps: InputProps = {
      type: InputType.Email,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
          {
            propKey: 'size',
            propValues: [undefined, InputSize.Large],
          },
          {
            propKey: 'icon',
            propValues: [undefined, SVGAsset.NavSearch],
          },
        ]}
      >
        <Input {...requiredProps} placeholder="Type Email" type={InputType.Email} />
        <Input {...requiredProps} placeholder="Type Number" type={InputType.Number} />
        <Input {...requiredProps} placeholder="Type Password" type={InputType.Password} />
        <Input {...requiredProps} placeholder="Type Search" type={InputType.Search} />
        <Input {...requiredProps} placeholder="Type Text" type={InputType.Text} />
      </CombinationGenerator>
    );
  }
}
