import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, InputSize, Layout, Radio, RadioProps, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormRadioPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Radio Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requiredProps: RadioProps = {
      label: 'Radio label',
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
        ]}
      >
        <Radio {...requiredProps} />
        <Radio {...requiredProps} size={InputSize.Large} />
      </CombinationGenerator>
    );
  }
}
